/*
 * Decompiled with CFR 0.152.
 */
package ru.entaxy.test.processor.congig;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentimentAnalysisConfig {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_COMMIT_INTERVAL_MS = 5000;
    private final String bootstrapServers;
    private final String applicationId;
    private final String sourceTopic;
    private final String targetTopic;
    private final int commitIntervalMs;
    private final String trustStorePassword;
    private final String trustStorePath;
    private final String keyStorePassword;
    private final String keyStorePath;
    private final String additionalConfig;

    public SentimentAnalysisConfig(String bootstrapServers, String applicationId, String sourceTopic, String targetTopic, int commitIntervalMs, String trustStorePassword, String trustStorePath, String keyStorePassword, String keyStorePath, String additionalConfig) {
        this.bootstrapServers = bootstrapServers;
        this.applicationId = applicationId;
        this.sourceTopic = sourceTopic;
        this.targetTopic = targetTopic;
        this.commitIntervalMs = commitIntervalMs;
        this.trustStorePassword = trustStorePassword;
        this.trustStorePath = trustStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyStorePath = keyStorePath;
        this.additionalConfig = additionalConfig;
    }

    public static SentimentAnalysisConfig fromEnv() {
        String bootstrapServers = System.getenv("BOOTSTRAP_SERVERS");
        String sourceTopic = System.getenv("SOURCE_TOPIC");
        String targetTopic = System.getenv("TARGET_TOPIC");
        String applicationId = System.getenv("APPLICATION_ID");
        int commitIntervalMs = System.getenv("COMMIT_INTERVAL_MS") == null ? 5000 : Integer.valueOf(System.getenv("COMMIT_INTERVAL_MS"));
        String trustStorePassword = System.getenv("TRUSTSTORE_PASSWORD") == null ? null : System.getenv("TRUSTSTORE_PASSWORD");
        String trustStorePath = System.getenv("TRUSTSTORE_PATH") == null ? null : System.getenv("TRUSTSTORE_PATH");
        String keyStorePassword = System.getenv("KEYSTORE_PASSWORD") == null ? null : System.getenv("KEYSTORE_PASSWORD");
        String keyStorePath = System.getenv("KEYSTORE_PATH") == null ? null : System.getenv("KEYSTORE_PATH");
        String additionalConfig = System.getenv().getOrDefault("ADDITIONAL_CONFIG", "");
        return new SentimentAnalysisConfig(bootstrapServers, applicationId, sourceTopic, targetTopic, commitIntervalMs, trustStorePassword, trustStorePath, keyStorePassword, keyStorePath, additionalConfig);
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getSourceTopic() {
        return this.sourceTopic;
    }

    public String getTargetTopic() {
        return this.targetTopic;
    }

    public int getCommitInterval() {
        return this.commitIntervalMs;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public String getAdditionalConfig() {
        return this.additionalConfig;
    }

    public String toString() {
        return "KafkaStreamsConfig{bootstrapServers='" + this.bootstrapServers + "', applicationId='" + this.applicationId + "', sourceTopic='" + this.sourceTopic + "', targetTopic='" + this.targetTopic + "', commitIntervalMs=" + this.commitIntervalMs + ", trustStorePassword='" + this.trustStorePassword + "', trustStorePath='" + this.trustStorePath + "', keyStorePassword='" + this.keyStorePassword + "', keyStorePath='" + this.keyStorePath + "', additionalConfig='" + this.additionalConfig + "'}";
    }
}

