/*
 * Decompiled with CFR 0.152.
 */
package ru.entaxy.test.processor;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.engine.EngineProvider;
import ai.djl.inference.Predictor;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.pytorch.engine.PtEngineProvider;
import ai.djl.pytorch.zoo.PtModelZoo;
import ai.djl.pytorch.zoo.PtZooProvider;
import ai.djl.pytorch.zoo.nlp.sentimentanalysis.PtDistilBertTranslatorFactory;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.repository.zoo.ZooProvider;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Progress;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.DecimalFormat;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.telegram.model.IncomingMessage;
import org.apache.camel.component.telegram.model.IncomingPhotoSize;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.entaxy.test.processor.congig.SentimentAnalysisConfig;

public class SentimentTGProcessor
implements Processor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static Predictor<String, Classifications> predictorTxt;
    protected static Predictor<Image, DetectedObjects> predictorImg;
    protected static boolean activated;

    public void process(Exchange exchange) throws Exception {
        SentimentAnalysisConfig config = SentimentAnalysisConfig.fromEnv();
        DecimalFormat f = new DecimalFormat("##.00");
        String botToken = (String)exchange.getIn().getHeader("tg.token");
        this.log.info(SentimentAnalysisConfig.class.getName() + ": {}", (Object)config.toString());
        try {
            if (!activated) {
                this.activate();
            }
            IncomingMessage inMsg = (IncomingMessage)exchange.getIn().getBody();
            Object reply = "\u041d\u0435\u0447\u0435\u0433\u043e \u0441\u043a\u0430\u0437\u0430\u0442\u044c...\ud83d\ude15";
            if (inMsg != null) {
                if (inMsg.getPhoto() != null && inMsg.getPhoto().size() > 0) {
                    Criteria criteria = Criteria.builder().optApplication(Application.CV.OBJECT_DETECTION).setTypes(Image.class, DetectedObjects.class).optFilter("backbone", "resnet50").build();
                    predictorImg = ModelZoo.loadModel((Criteria)criteria).newPredictor();
                    IncomingPhotoSize photo = (IncomingPhotoSize)inMsg.getPhoto().get(0);
                    String id = photo.getFileId();
                    String url = "https://api.telegram.org/bot" + botToken + "/getFile?file_id=" + id;
                    HttpClient client = HttpClient.newHttpClient();
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    JSONObject jsonObj = new JSONObject(response.body());
                    jsonObj = jsonObj.getJSONObject("result");
                    url = "https://api.telegram.org/file/bot" + botToken + "/" + jsonObj.getString("file_path");
                    Image img = ImageFactory.getInstance().fromUrl(url);
                    DetectedObjects detected = (DetectedObjects)predictorImg.predict((Object)img);
                    if (detected.getNumberOfObjects() == 0) {
                        reply = "No objects were detected in your photo \ud83d\ude15";
                    } else {
                        reply = "\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b \u0431\u044b\u043b\u0438 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u043d\u0430 \u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0435:\n";
                        for (Classifications.Classification classification : detected.items()) {
                            reply = (String)reply + "- " + classification.getClassName() + " (\u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e\u0441\u0442\u044c " + f.format(classification.getProbability() * 100.0) + "%)\n";
                        }
                    }
                } else if (inMsg.getText() != null) {
                    Criteria criteria = Criteria.builder().optApplication(Application.NLP.SENTIMENT_ANALYSIS).setTypes(String.class, Classifications.class).build();
                    predictorTxt = ModelZoo.loadModel((Criteria)criteria).newPredictor();
                    Classifications classifications = (Classifications)predictorTxt.predict((Object)inMsg.getText());
                    reply = "\u0412\u0430\u0448\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435  \u0431\u044b\u043b\u043e " + classifications.best().getClassName() + " \u0441 \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e\u0441\u0442\u044c\u044e " + f.format(classifications.best().getProbability() * 100.0) + "%";
                }
            }
            exchange.getIn().setBody(reply);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            this.log.error("Failed to load model", e);
        }
    }

    protected synchronized void activate() throws ModelNotFoundException, MalformedModelException, IOException {
        if (!activated) {
            this.log.info(">>>>>>Activating...");
            ru.entaxy.test.djl.util.PtModelZoo ptModel = new ru.entaxy.test.djl.util.PtModelZoo();
            PtZooProvider ptProvider = new PtZooProvider();
            PtModelZoo.registerModelZoo((ZooProvider)ptProvider);
            PtEngineProvider ptEngineProvider = new PtEngineProvider();
            Engine.registerEngine((EngineProvider)ptEngineProvider);
            PtDistilBertTranslatorFactory trFactory = new PtDistilBertTranslatorFactory();
            Criteria criteria = Criteria.builder().optModelZoo((ModelZoo)ptModel).optTranslatorFactory((TranslatorFactory)trFactory).optEngine("PyTorch").setTypes(String.class, Classifications.class).optDevice(Device.cpu()).optProgress((Progress)new ProgressBar()).build();
            ZooModel model = criteria.loadModel();
            this.log.info(">>>>>>Activation completed...");
            activated = true;
        }
    }

    static {
        activated = false;
    }
}

